# -*- coding: utf-8 -*-
"""velocityのデータを入力する．
__version__ = 1.02

trainのframe数と同じデータ点を速度の配列を返すような関数として定義する．
(2023/12の実験： 4092frame)
速度関数の形状は任意．例)三角波，sin波，複数のsin波など...

"""
import numpy as np
# import matplotlib.pyplot as plt
from scipy import signal
import inspect
# from nbm_module.calcM import rounding_half_up
######################################################################################



# rawdataN = トランスデューサの1周期に対応するframe数
# turn_num = train内で折り返す回数。
# summed_shift = 速度の中心位置のズレのframe数（大雑把なシフト）
# shiftplus = 速度の中心位置のズレの量（微調整）


#高速
def __calibration_velocity_0(shiftPLUS=None):
    if shiftPLUS is None: shiftPLUS = 0.0233+0.017+0.001  # フォールディング微調整 1ch0.00011408のシフト量
    rawdataN = 4092  #saito202503　　
    turn_num = 4 #saito202503
    summed_shift = 0
    BG_average_num = 50
    __VELOCITY_CUT_MIN = -120
    __VELOCITY_CUT_MAX = 120
    CUT_VELOCITY = True
    
    cycle_Hz = 8.4951483231  # [Hz]
    cycle_s = 1/cycle_Hz # [x]
    
    def modelfunc(x_array, shiftPLUS=0):
        # fit: y = 244.6082305908203x + 0.03799820691347122
        a = 263.86 #244.6082305908203
        # b = 0.03799820691347122    

        # 定義域：-0.265s ~ 0.265s
        __velocfunc = np.zeros(x_array.shape)
        for indx, _x in enumerate(x_array):
            if (_x>-cycle_s*(9/4)-shiftPLUS) and (_x<-cycle_s*(7/4)-shiftPLUS):    #saito202503　関数を修正
                __velocfunc[indx] = a*(_x+cycle_s*(8/4)+shiftPLUS)
            elif (_x>-cycle_s*(7/4)-shiftPLUS) and (_x<-cycle_s*(5/4)-shiftPLUS):
                __velocfunc[indx] = -a*(_x+cycle_s*(6/4)+shiftPLUS)
            elif (_x>-cycle_s*(5/4)-shiftPLUS) and (_x<-cycle_s*(3/4)-shiftPLUS):
                __velocfunc[indx] = a*(_x+cycle_s*(4/4)+shiftPLUS)
            elif (_x>-cycle_s*(3/4)-shiftPLUS) and (_x<-cycle_s*(1/4)-shiftPLUS):
                __velocfunc[indx] = -a*(_x+cycle_s*(2/4)+shiftPLUS)
            elif (_x>-cycle_s*(1/4)-shiftPLUS) and (_x<cycle_s*(1/4)-shiftPLUS):
                __velocfunc[indx] = a*(_x+cycle_s*(0/4)+shiftPLUS)
            elif (_x>cycle_s*(1/4)-shiftPLUS) and (_x<cycle_s*(3/4)-shiftPLUS):
                __velocfunc[indx] = -a*(_x-cycle_s*(2/4)+shiftPLUS)
            elif (_x>cycle_s*(3/4)-shiftPLUS) and (_x<cycle_s*(5/4)-shiftPLUS):
                __velocfunc[indx] = a*(_x-cycle_s*(4/4)+shiftPLUS)
            elif (_x>cycle_s*(5/4)-shiftPLUS) and (_x<cycle_s*(7/4)-shiftPLUS):
                __velocfunc[indx] = -a*(_x-cycle_s*(6/4)+shiftPLUS)
            elif (_x>cycle_s*(7/4)-shiftPLUS) and (_x<cycle_s*(9/4)-shiftPLUS):
                __velocfunc[indx] = a*(_x-cycle_s*(8/4)+shiftPLUS)
            elif (_x>cycle_s*(9/4)-shiftPLUS) and (_x<cycle_s*(11/4)-shiftPLUS):
                __velocfunc[indx] = -a*(_x-cycle_s*(10/4)+shiftPLUS)
            elif (_x>cycle_s*(11/4)-shiftPLUS) and (_x<cycle_s*(13/4)-shiftPLUS):
                __velocfunc[indx] = a*(_x-cycle_s*(12/4)+shiftPLUS)
            elif (_x>cycle_s*(13/4)-shiftPLUS) and (_x<cycle_s*(15/4)-shiftPLUS):
                __velocfunc[indx] = -a*(_x-cycle_s*(14/4)+shiftPLUS)
            elif (_x>cycle_s*(15/4)-shiftPLUS) and (_x<cycle_s*(17/4)-shiftPLUS):
                __velocfunc[indx] = a*(_x-cycle_s*(16/4)+shiftPLUS)
            elif (_x>cycle_s*(17/4)-shiftPLUS) and (_x<cycle_s*(19/4)-shiftPLUS):
                __velocfunc[indx] = -a*(_x-cycle_s*(18/4)+shiftPLUS)
            elif (_x>cycle_s*(19/4)-shiftPLUS) and (_x<cycle_s*(21/4)-shiftPLUS):
                __velocfunc[indx] = a*(_x-cycle_s*(20/4)+shiftPLUS)    
            else:
                __velocfunc[indx] = 0
        return __velocfunc*20 # レーザキャリブレータのレンジが0.02のとき：20倍
    

    xd = np.linspace(0, turn_num*cycle_s, rawdataN)  # [s] #saito202503  turn_numかける
    estimated_curve = modelfunc(xd, shiftPLUS=shiftPLUS)

    data_velocityX = xd
    data_velocityY = estimated_curve.copy()
    data_velocityY_resol = estimated_curve.copy()

    print("MIN velocity[mm/s];  ", np.min(data_velocityY))
    print("MAX velocity[mm/s];  ", np.max(data_velocityY))
    params = {'rawdataN':rawdataN, 
              'turn_num':turn_num, 
              'summed_shift':summed_shift,
              'shiftPLUS':shiftPLUS,
              'BG_average_num':BG_average_num,
              '__VELOCITY_CUT_MIN':__VELOCITY_CUT_MIN,
              '__VELOCITY_CUT_MAX':__VELOCITY_CUT_MAX, 
              'CUT_VELOCITY':CUT_VELOCITY}
    return data_velocityX, data_velocityY, data_velocityY_resol, params


#中速
def __calibration_velocity_1(shiftPLUS=None):
    if shiftPLUS is None: shiftPLUS = 0.0232+0.017+0.0017  # フォールディング微調整 1ch0.00011408のシフト量
    rawdataN = 4092  #saito202503　　
    turn_num = 4 #saito202503
    summed_shift = 0
    BG_average_num = 25
    __VELOCITY_CUT_MIN = -35
    __VELOCITY_CUT_MAX = 35
    CUT_VELOCITY = True
    
    cycle_Hz = 8.496  # [Hz] トランスデューサのFGの周波数
    cycle_s = 1/cycle_Hz # [x]
    
    def modelfunc(x_array, shiftPLUS=0):
        # fit: y = 244.6082305908203x + 0.03799820691347122
        a = 75.193
        # b = 0.061044

        # 定義域：-0.265s ~ 0.265s
        __velocfunc = np.zeros(x_array.shape)
        for indx, _x in enumerate(x_array):
            if (_x>-cycle_s*(9/4)-shiftPLUS) and (_x<-cycle_s*(7/4)-shiftPLUS):    #saito202503　関数を修正
                __velocfunc[indx] = a*(_x+cycle_s*(8/4)+shiftPLUS)
            elif (_x>-cycle_s*(7/4)-shiftPLUS) and (_x<-cycle_s*(5/4)-shiftPLUS):
                __velocfunc[indx] = -a*(_x+cycle_s*(6/4)+shiftPLUS)
            elif (_x>-cycle_s*(5/4)-shiftPLUS) and (_x<-cycle_s*(3/4)-shiftPLUS):
                __velocfunc[indx] = a*(_x+cycle_s*(4/4)+shiftPLUS)
            elif (_x>-cycle_s*(3/4)-shiftPLUS) and (_x<-cycle_s*(1/4)-shiftPLUS):
                __velocfunc[indx] = -a*(_x+cycle_s*(2/4)+shiftPLUS)
            elif (_x>-cycle_s*(1/4)-shiftPLUS) and (_x<cycle_s*(1/4)-shiftPLUS):
                __velocfunc[indx] = a*(_x+cycle_s*(0/4)+shiftPLUS)
            elif (_x>cycle_s*(1/4)-shiftPLUS) and (_x<cycle_s*(3/4)-shiftPLUS):
                __velocfunc[indx] = -a*(_x-cycle_s*(2/4)+shiftPLUS)
            elif (_x>cycle_s*(3/4)-shiftPLUS) and (_x<cycle_s*(5/4)-shiftPLUS):
                __velocfunc[indx] = a*(_x-cycle_s*(4/4)+shiftPLUS)
            elif (_x>cycle_s*(5/4)-shiftPLUS) and (_x<cycle_s*(7/4)-shiftPLUS):
                __velocfunc[indx] = -a*(_x-cycle_s*(6/4)+shiftPLUS)
            elif (_x>cycle_s*(7/4)-shiftPLUS) and (_x<cycle_s*(9/4)-shiftPLUS):
                __velocfunc[indx] = a*(_x-cycle_s*(8/4)+shiftPLUS)
            elif (_x>cycle_s*(9/4)-shiftPLUS) and (_x<cycle_s*(11/4)-shiftPLUS):
                __velocfunc[indx] = -a*(_x-cycle_s*(10/4)+shiftPLUS)
            elif (_x>cycle_s*(11/4)-shiftPLUS) and (_x<cycle_s*(13/4)-shiftPLUS):
                __velocfunc[indx] = a*(_x-cycle_s*(12/4)+shiftPLUS)
            elif (_x>cycle_s*(13/4)-shiftPLUS) and (_x<cycle_s*(15/4)-shiftPLUS):
                __velocfunc[indx] = -a*(_x-cycle_s*(14/4)+shiftPLUS)
            elif (_x>cycle_s*(15/4)-shiftPLUS) and (_x<cycle_s*(17/4)-shiftPLUS):
                __velocfunc[indx] = a*(_x-cycle_s*(16/4)+shiftPLUS)
            elif (_x>cycle_s*(17/4)-shiftPLUS) and (_x<cycle_s*(19/4)-shiftPLUS):
                __velocfunc[indx] = -a*(_x-cycle_s*(18/4)+shiftPLUS)
            elif (_x>cycle_s*(19/4)-shiftPLUS) and (_x<cycle_s*(21/4)-shiftPLUS):
                __velocfunc[indx] = a*(_x-cycle_s*(20/4)+shiftPLUS)    
            else:
                __velocfunc[indx] = 0
        return __velocfunc*20 # レーザキャリブレータのレンジが0.02のとき：20倍
    

    xd = np.linspace(0, turn_num*cycle_s, rawdataN)  # [s] #saito202503  turn_numかける
    estimated_curve = modelfunc(xd, shiftPLUS=shiftPLUS)

    data_velocityX = xd
    data_velocityY = estimated_curve.copy()
    data_velocityY_resol = estimated_curve.copy()

    print("MIN velocity[mm/s];  ", np.min(data_velocityY))
    print("MAX velocity[mm/s];  ", np.max(data_velocityY))
    params = {'rawdataN':rawdataN, 
              'turn_num':turn_num, 
              'summed_shift':summed_shift,
              'shiftPLUS':shiftPLUS,
              'BG_average_num':BG_average_num,
              '__VELOCITY_CUT_MIN':__VELOCITY_CUT_MIN,
              '__VELOCITY_CUT_MAX':__VELOCITY_CUT_MAX, 
              'CUT_VELOCITY':CUT_VELOCITY}
    return data_velocityX, data_velocityY, data_velocityY_resol, params


#高速２
def __calibration_velocity_2(shiftPLUS=None):
    if shiftPLUS is None: shiftPLUS = 0.0014+0.000 #0.0014 # フォールディング微調整 1ch0.00011408のシフト量
    rawdataN = 4092  #saito202503　
    turn_num = 4  #saito202503　
    summed_shift = 0
    BG_average_num = 50
    __VELOCITY_CUT_MIN = -120
    __VELOCITY_CUT_MAX = 120
    CUT_VELOCITY = True
    
    cycle_Hz = 8.496  # [Hz]
    cycle_s = 1/cycle_Hz # [x]
    
    def modelfunc(x_array, shiftPLUS=0):
        # fit: y = 244.6082305908203x + 0.03799820691347122
        a = 244.6082305908203
        # b = 0.03799820691347122  

        # 定義域：-0.265s ~ 0.265s
        __velocfunc = np.zeros(x_array.shape)
        for indx, _x in enumerate(x_array):
            if (_x>-cycle_s*(9/4)-shiftPLUS) and (_x<-cycle_s*(7/4)-shiftPLUS):    #saito202503　関数を修正
                __velocfunc[indx] = a*(_x+cycle_s*(8/4)+shiftPLUS)
            elif (_x>-cycle_s*(7/4)-shiftPLUS) and (_x<-cycle_s*(5/4)-shiftPLUS):
                __velocfunc[indx] = -a*(_x+cycle_s*(6/4)+shiftPLUS)
            elif (_x>-cycle_s*(5/4)-shiftPLUS) and (_x<-cycle_s*(3/4)-shiftPLUS):
                __velocfunc[indx] = a*(_x+cycle_s*(4/4)+shiftPLUS)
            elif (_x>-cycle_s*(3/4)-shiftPLUS) and (_x<-cycle_s*(1/4)-shiftPLUS):
                __velocfunc[indx] = -a*(_x+cycle_s*(2/4)+shiftPLUS)
            elif (_x>-cycle_s*(1/4)-shiftPLUS) and (_x<cycle_s*(1/4)-shiftPLUS):
                __velocfunc[indx] = a*(_x+cycle_s*(0/4)+shiftPLUS)
            elif (_x>cycle_s*(1/4)-shiftPLUS) and (_x<cycle_s*(3/4)-shiftPLUS):
                __velocfunc[indx] = -a*(_x-cycle_s*(2/4)+shiftPLUS)
            elif (_x>cycle_s*(3/4)-shiftPLUS) and (_x<cycle_s*(5/4)-shiftPLUS):
                __velocfunc[indx] = a*(_x-cycle_s*(4/4)+shiftPLUS)
            elif (_x>cycle_s*(5/4)-shiftPLUS) and (_x<cycle_s*(7/4)-shiftPLUS):
                __velocfunc[indx] = -a*(_x-cycle_s*(6/4)+shiftPLUS)
            elif (_x>cycle_s*(7/4)-shiftPLUS) and (_x<cycle_s*(9/4)-shiftPLUS):
                __velocfunc[indx] = a*(_x-cycle_s*(8/4)+shiftPLUS)
            elif (_x>cycle_s*(9/4)-shiftPLUS) and (_x<cycle_s*(11/4)-shiftPLUS):
                __velocfunc[indx] = -a*(_x-cycle_s*(10/4)+shiftPLUS)
            elif (_x>cycle_s*(11/4)-shiftPLUS) and (_x<cycle_s*(13/4)-shiftPLUS):
                __velocfunc[indx] = a*(_x-cycle_s*(12/4)+shiftPLUS)
            elif (_x>cycle_s*(13/4)-shiftPLUS) and (_x<cycle_s*(15/4)-shiftPLUS):
                __velocfunc[indx] = -a*(_x-cycle_s*(14/4)+shiftPLUS)
            elif (_x>cycle_s*(15/4)-shiftPLUS) and (_x<cycle_s*(17/4)-shiftPLUS):
                __velocfunc[indx] = a*(_x-cycle_s*(16/4)+shiftPLUS)
            elif (_x>cycle_s*(17/4)-shiftPLUS) and (_x<cycle_s*(19/4)-shiftPLUS):
                __velocfunc[indx] = -a*(_x-cycle_s*(18/4)+shiftPLUS)
            elif (_x>cycle_s*(19/4)-shiftPLUS) and (_x<cycle_s*(21/4)-shiftPLUS):
                __velocfunc[indx] = a*(_x-cycle_s*(20/4)+shiftPLUS)    
            else:
                __velocfunc[indx] = 0
        return __velocfunc*20 # レーザキャリブレータのレンジが0.02のとき：20倍
    

    xd = np.linspace(0, turn_num*cycle_s, rawdataN)  # [s] #saito202503  turn_numかける
    estimated_curve = modelfunc(xd, shiftPLUS=shiftPLUS)

    data_velocityX = xd
    data_velocityY = estimated_curve.copy()
    data_velocityY_resol = estimated_curve.copy()

    print("MIN velocity[mm/s];  ", np.min(data_velocityY))
    print("MAX velocity[mm/s];  ", np.max(data_velocityY))
    params = {'rawdataN':rawdataN, 
              'turn_num':turn_num, 
              'summed_shift':summed_shift,
              'shiftPLUS':shiftPLUS,
              'BG_average_num':BG_average_num,
              '__VELOCITY_CUT_MIN':__VELOCITY_CUT_MIN,
              '__VELOCITY_CUT_MAX':__VELOCITY_CUT_MAX, 
              'CUT_VELOCITY':CUT_VELOCITY}
    return data_velocityX, data_velocityY, data_velocityY_resol, params


#低速
def __calibration_velocity_3(shiftPLUS=None):
    if shiftPLUS is None: shiftPLUS = 0.0228 #-0.005 #0.0014 # フォールディング微調整 1ch0.00011408のシフト量
    rawdataN = 4092  #saito202503　　
    turn_num = 4 #saito202503
    summed_shift = 0
    BG_average_num = 50
    __VELOCITY_CUT_MIN = -4
    __VELOCITY_CUT_MAX = 4
    CUT_VELOCITY = True
    
    cycle_Hz = 8.496  #202407 8.4951483231/2  # [Hz]
    cycle_s = 1/cycle_Hz # [x]
    
    def modelfunc(x_array, shiftPLUS=0):
        # fit: y = 244.6082305908203x + 0.03799820691347122
        a = 7.5045 #2024/7  7.196/2
        # b = 0.004651  

        # 定義域：-0.265s ~ 0.265s
        __velocfunc = np.zeros(x_array.shape)
        for indx, _x in enumerate(x_array):
            if (_x>-cycle_s*(9/4)-shiftPLUS) and (_x<-cycle_s*(7/4)-shiftPLUS):    #saito202503　関数を修正
                __velocfunc[indx] = a*(_x+cycle_s*(8/4)+shiftPLUS)
            elif (_x>-cycle_s*(7/4)-shiftPLUS) and (_x<-cycle_s*(5/4)-shiftPLUS):
                __velocfunc[indx] = -a*(_x+cycle_s*(6/4)+shiftPLUS)
            elif (_x>-cycle_s*(5/4)-shiftPLUS) and (_x<-cycle_s*(3/4)-shiftPLUS):
                __velocfunc[indx] = a*(_x+cycle_s*(4/4)+shiftPLUS)
            elif (_x>-cycle_s*(3/4)-shiftPLUS) and (_x<-cycle_s*(1/4)-shiftPLUS):
                __velocfunc[indx] = -a*(_x+cycle_s*(2/4)+shiftPLUS)
            elif (_x>-cycle_s*(1/4)-shiftPLUS) and (_x<cycle_s*(1/4)-shiftPLUS):
                __velocfunc[indx] = a*(_x+cycle_s*(0/4)+shiftPLUS)
            elif (_x>cycle_s*(1/4)-shiftPLUS) and (_x<cycle_s*(3/4)-shiftPLUS):
                __velocfunc[indx] = -a*(_x-cycle_s*(2/4)+shiftPLUS)
            elif (_x>cycle_s*(3/4)-shiftPLUS) and (_x<cycle_s*(5/4)-shiftPLUS):
                __velocfunc[indx] = a*(_x-cycle_s*(4/4)+shiftPLUS)
            elif (_x>cycle_s*(5/4)-shiftPLUS) and (_x<cycle_s*(7/4)-shiftPLUS):
                __velocfunc[indx] = -a*(_x-cycle_s*(6/4)+shiftPLUS)
            elif (_x>cycle_s*(7/4)-shiftPLUS) and (_x<cycle_s*(9/4)-shiftPLUS):
                __velocfunc[indx] = a*(_x-cycle_s*(8/4)+shiftPLUS)
            elif (_x>cycle_s*(9/4)-shiftPLUS) and (_x<cycle_s*(11/4)-shiftPLUS):
                __velocfunc[indx] = -a*(_x-cycle_s*(10/4)+shiftPLUS)
            elif (_x>cycle_s*(11/4)-shiftPLUS) and (_x<cycle_s*(13/4)-shiftPLUS):
                __velocfunc[indx] = a*(_x-cycle_s*(12/4)+shiftPLUS)
            elif (_x>cycle_s*(13/4)-shiftPLUS) and (_x<cycle_s*(15/4)-shiftPLUS):
                __velocfunc[indx] = -a*(_x-cycle_s*(14/4)+shiftPLUS)
            elif (_x>cycle_s*(15/4)-shiftPLUS) and (_x<cycle_s*(17/4)-shiftPLUS):
                __velocfunc[indx] = a*(_x-cycle_s*(16/4)+shiftPLUS)
            elif (_x>cycle_s*(17/4)-shiftPLUS) and (_x<cycle_s*(19/4)-shiftPLUS):
                __velocfunc[indx] = -a*(_x-cycle_s*(18/4)+shiftPLUS)
            elif (_x>cycle_s*(19/4)-shiftPLUS) and (_x<cycle_s*(21/4)-shiftPLUS):
                __velocfunc[indx] = a*(_x-cycle_s*(20/4)+shiftPLUS)    
            else:
                __velocfunc[indx] = 0
        return __velocfunc*20 # レーザキャリブレータのレンジが0.02のとき：20倍
    

    xd = np.linspace(0, turn_num*cycle_s, rawdataN)  # [s] #saito202503  turn_numかける
    estimated_curve = modelfunc(xd, shiftPLUS=shiftPLUS)

    data_velocityX = xd
    data_velocityY = estimated_curve.copy()
    data_velocityY_resol = estimated_curve.copy()

    print("MIN velocity[mm/s];  ", np.min(data_velocityY))
    print("MAX velocity[mm/s];  ", np.max(data_velocityY))
    params = {'rawdataN':rawdataN, 
              'turn_num':turn_num, 
              'summed_shift':summed_shift,
              'shiftPLUS':shiftPLUS,
              'BG_average_num':BG_average_num,
              '__VELOCITY_CUT_MIN':__VELOCITY_CUT_MIN,
              '__VELOCITY_CUT_MAX':__VELOCITY_CUT_MAX, 
              'CUT_VELOCITY':CUT_VELOCITY}
    return data_velocityX, data_velocityY, data_velocityY_resol, params


def __calibration_velocity_4(shiftPLUS=None):
    if shiftPLUS is None: shiftPLUS = 0.0605+0.00000  # フォールディング微調整 1ch0.00011408のシフト量
    rawdataN = 4092  #saito202503　　
    turn_num = 4 #saito202503
    summed_shift = 0
    BG_average_num = 25
    __VELOCITY_CUT_MIN = -35
    __VELOCITY_CUT_MAX = 35
    CUT_VELOCITY = True
    
    cycle_Hz = 8.496  # [Hz] トランスデューサのFGの周波数
    cycle_s = 1/cycle_Hz # [x]
    
    def modelfunc(x_array, shiftPLUS=0):
        # fit: y = 244.6082305908203x + 0.03799820691347122
        a = 73.209/2
        # b = 0.061044

        # 定義域：-0.265s ~ 0.265s
        __velocfunc = np.zeros(x_array.shape)
        for indx, _x in enumerate(x_array):
            if (_x>-cycle_s*(9/4)-shiftPLUS) and (_x<-cycle_s*(7/4)-shiftPLUS):    #saito202503　関数を修正
                __velocfunc[indx] = a*(_x+cycle_s*(8/4)+shiftPLUS)
            elif (_x>-cycle_s*(7/4)-shiftPLUS) and (_x<-cycle_s*(5/4)-shiftPLUS):
                __velocfunc[indx] = -a*(_x+cycle_s*(6/4)+shiftPLUS)
            elif (_x>-cycle_s*(5/4)-shiftPLUS) and (_x<-cycle_s*(3/4)-shiftPLUS):
                __velocfunc[indx] = a*(_x+cycle_s*(4/4)+shiftPLUS)
            elif (_x>-cycle_s*(3/4)-shiftPLUS) and (_x<-cycle_s*(1/4)-shiftPLUS):
                __velocfunc[indx] = -a*(_x+cycle_s*(2/4)+shiftPLUS)
            elif (_x>-cycle_s*(1/4)-shiftPLUS) and (_x<cycle_s*(1/4)-shiftPLUS):
                __velocfunc[indx] = a*(_x+cycle_s*(0/4)+shiftPLUS)
            elif (_x>cycle_s*(1/4)-shiftPLUS) and (_x<cycle_s*(3/4)-shiftPLUS):
                __velocfunc[indx] = -a*(_x-cycle_s*(2/4)+shiftPLUS)
            elif (_x>cycle_s*(3/4)-shiftPLUS) and (_x<cycle_s*(5/4)-shiftPLUS):
                __velocfunc[indx] = a*(_x-cycle_s*(4/4)+shiftPLUS)
            elif (_x>cycle_s*(5/4)-shiftPLUS) and (_x<cycle_s*(7/4)-shiftPLUS):
                __velocfunc[indx] = -a*(_x-cycle_s*(6/4)+shiftPLUS)
            elif (_x>cycle_s*(7/4)-shiftPLUS) and (_x<cycle_s*(9/4)-shiftPLUS):
                __velocfunc[indx] = a*(_x-cycle_s*(8/4)+shiftPLUS)
            elif (_x>cycle_s*(9/4)-shiftPLUS) and (_x<cycle_s*(11/4)-shiftPLUS):
                __velocfunc[indx] = -a*(_x-cycle_s*(10/4)+shiftPLUS)
            elif (_x>cycle_s*(11/4)-shiftPLUS) and (_x<cycle_s*(13/4)-shiftPLUS):
                __velocfunc[indx] = a*(_x-cycle_s*(12/4)+shiftPLUS)
            elif (_x>cycle_s*(13/4)-shiftPLUS) and (_x<cycle_s*(15/4)-shiftPLUS):
                __velocfunc[indx] = -a*(_x-cycle_s*(14/4)+shiftPLUS)
            elif (_x>cycle_s*(15/4)-shiftPLUS) and (_x<cycle_s*(17/4)-shiftPLUS):
                __velocfunc[indx] = a*(_x-cycle_s*(16/4)+shiftPLUS)
            elif (_x>cycle_s*(17/4)-shiftPLUS) and (_x<cycle_s*(19/4)-shiftPLUS):
                __velocfunc[indx] = -a*(_x-cycle_s*(18/4)+shiftPLUS)
            elif (_x>cycle_s*(19/4)-shiftPLUS) and (_x<cycle_s*(21/4)-shiftPLUS):
                __velocfunc[indx] = a*(_x-cycle_s*(20/4)+shiftPLUS)    
            else:
                __velocfunc[indx] = 0
        return __velocfunc*20 # レーザキャリブレータのレンジが0.02のとき：20倍
    

    xd = np.linspace(0, turn_num*cycle_s, rawdataN)  # [s] #saito202503  turn_numかける
    estimated_curve = modelfunc(xd, shiftPLUS=shiftPLUS)

    data_velocityX = xd
    data_velocityY = estimated_curve.copy()
    data_velocityY_resol = estimated_curve.copy()

    print("MIN velocity[mm/s];  ", np.min(data_velocityY))
    print("MAX velocity[mm/s];  ", np.max(data_velocityY))
    params = {'rawdataN':rawdataN, 
              'turn_num':turn_num, 
              'summed_shift':summed_shift,
              'shiftPLUS':shiftPLUS,
              'BG_average_num':BG_average_num,
              '__VELOCITY_CUT_MIN':__VELOCITY_CUT_MIN,
              '__VELOCITY_CUT_MAX':__VELOCITY_CUT_MAX, 
              'CUT_VELOCITY':CUT_VELOCITY}
    return data_velocityX, data_velocityY, data_velocityY_resol, params




def __calibration_velocity_5(shiftPLUS=None):
    if shiftPLUS is None: shiftPLUS = 0.0232+0.017+0.0017  # フォールディング微調整 1ch0.00011408のシフト量
    rawdataN = 4092  #saito202503　　
    turn_num = 4 #saito202503
    summed_shift = 0
    BG_average_num = 25
    __VELOCITY_CUT_MIN = -35
    __VELOCITY_CUT_MAX = 35
    CUT_VELOCITY = True
    
    cycle_Hz = 8.496  # [Hz] トランスデューサのFGの周波数
    cycle_s = 1/cycle_Hz # [x]
    
    def modelfunc(x_array, shiftPLUS=0):
        # fit: y = 244.6082305908203x + 0.03799820691347122
        a = 75.193
        # b = 0.061044

        # 定義域：-0.265s ~ 0.265s
        __velocfunc = np.zeros(x_array.shape)
        for indx, _x in enumerate(x_array):
            if (_x>-cycle_s*(9/4)-shiftPLUS) and (_x<-cycle_s*(7/4)-shiftPLUS):    #saito202503　関数を修正
                __velocfunc[indx] = a*(_x+cycle_s*(8/4)+shiftPLUS)
            elif (_x>-cycle_s*(7/4)-shiftPLUS) and (_x<-cycle_s*(5/4)-shiftPLUS):
                __velocfunc[indx] = -a*(_x+cycle_s*(6/4)+shiftPLUS)
            elif (_x>-cycle_s*(5/4)-shiftPLUS) and (_x<-cycle_s*(3/4)-shiftPLUS):
                __velocfunc[indx] = a*(_x+cycle_s*(4/4)+shiftPLUS)
            elif (_x>-cycle_s*(3/4)-shiftPLUS) and (_x<-cycle_s*(1/4)-shiftPLUS):
                __velocfunc[indx] = -a*(_x+cycle_s*(2/4)+shiftPLUS)
            elif (_x>-cycle_s*(1/4)-shiftPLUS) and (_x<cycle_s*(1/4)-shiftPLUS):
                __velocfunc[indx] = a*(_x+cycle_s*(0/4)+shiftPLUS)
            elif (_x>cycle_s*(1/4)-shiftPLUS) and (_x<cycle_s*(3/4)-shiftPLUS):
                __velocfunc[indx] = -a*(_x-cycle_s*(2/4)+shiftPLUS)
            elif (_x>cycle_s*(3/4)-shiftPLUS) and (_x<cycle_s*(5/4)-shiftPLUS):
                __velocfunc[indx] = a*(_x-cycle_s*(4/4)+shiftPLUS)
            elif (_x>cycle_s*(5/4)-shiftPLUS) and (_x<cycle_s*(7/4)-shiftPLUS):
                __velocfunc[indx] = -a*(_x-cycle_s*(6/4)+shiftPLUS)
            elif (_x>cycle_s*(7/4)-shiftPLUS) and (_x<cycle_s*(9/4)-shiftPLUS):
                __velocfunc[indx] = a*(_x-cycle_s*(8/4)+shiftPLUS)
            elif (_x>cycle_s*(9/4)-shiftPLUS) and (_x<cycle_s*(11/4)-shiftPLUS):
                __velocfunc[indx] = -a*(_x-cycle_s*(10/4)+shiftPLUS)
            elif (_x>cycle_s*(11/4)-shiftPLUS) and (_x<cycle_s*(13/4)-shiftPLUS):
                __velocfunc[indx] = a*(_x-cycle_s*(12/4)+shiftPLUS)
            elif (_x>cycle_s*(13/4)-shiftPLUS) and (_x<cycle_s*(15/4)-shiftPLUS):
                __velocfunc[indx] = -a*(_x-cycle_s*(14/4)+shiftPLUS)
            elif (_x>cycle_s*(15/4)-shiftPLUS) and (_x<cycle_s*(17/4)-shiftPLUS):
                __velocfunc[indx] = a*(_x-cycle_s*(16/4)+shiftPLUS)
            elif (_x>cycle_s*(17/4)-shiftPLUS) and (_x<cycle_s*(19/4)-shiftPLUS):
                __velocfunc[indx] = -a*(_x-cycle_s*(18/4)+shiftPLUS)
            elif (_x>cycle_s*(19/4)-shiftPLUS) and (_x<cycle_s*(21/4)-shiftPLUS):
                __velocfunc[indx] = a*(_x-cycle_s*(20/4)+shiftPLUS)    
            else:
                __velocfunc[indx] = 0
        return __velocfunc*20 # レーザキャリブレータのレンジが0.02のとき：20倍
    

    xd = np.linspace(0, turn_num*cycle_s, rawdataN)  # [s]
    estimated_curve = modelfunc(xd, shiftPLUS=shiftPLUS)

    data_velocityX = xd
    data_velocityY = estimated_curve.copy()
    data_velocityY_resol = estimated_curve.copy()

    print("MIN velocity[mm/s];  ", np.min(data_velocityY))
    print("MAX velocity[mm/s];  ", np.max(data_velocityY))
    params = {'rawdataN':rawdataN, 
              'turn_num':turn_num, 
              'summed_shift':summed_shift,
              'shiftPLUS':shiftPLUS,
              'BG_average_num':BG_average_num,
              '__VELOCITY_CUT_MIN':__VELOCITY_CUT_MIN,
              '__VELOCITY_CUT_MAX':__VELOCITY_CUT_MAX, 
              'CUT_VELOCITY':CUT_VELOCITY}
    return data_velocityX, data_velocityY, data_velocityY_resol, params



def __calibration_velocity_6(shiftPLUS=None):
    if shiftPLUS is None: shiftPLUS = 0.0233+0.017+0.001  # フォールディング微調整 1ch0.00011408のシフト量
    rawdataN = 4092  #saito202503　　
    turn_num = 4 #saito202503
    summed_shift = 0
    BG_average_num = 50
    __VELOCITY_CUT_MIN = -120
    __VELOCITY_CUT_MAX = 120
    CUT_VELOCITY = True
    
    cycle_Hz = 8.4951483231  # [Hz]
    cycle_s = 1/cycle_Hz # [x]
    
    def modelfunc(x_array, shiftPLUS=0):
        # fit: y = 244.6082305908203x + 0.03799820691347122
        a = 263.86 #244.6082305908203
        # b = 0.03799820691347122    

        # 定義域：-0.265s ~ 0.265s
        __velocfunc = np.zeros(x_array.shape)
        for indx, _x in enumerate(x_array):
            if (_x>-cycle_s*(9/4)-shiftPLUS) and (_x<-cycle_s*(7/4)-shiftPLUS):    #saito202503　関数を修正
                __velocfunc[indx] = a*(_x+cycle_s*(8/4)+shiftPLUS)
            elif (_x>-cycle_s*(7/4)-shiftPLUS) and (_x<-cycle_s*(5/4)-shiftPLUS):
                __velocfunc[indx] = -a*(_x+cycle_s*(6/4)+shiftPLUS)
            elif (_x>-cycle_s*(5/4)-shiftPLUS) and (_x<-cycle_s*(3/4)-shiftPLUS):
                __velocfunc[indx] = a*(_x+cycle_s*(4/4)+shiftPLUS)
            elif (_x>-cycle_s*(3/4)-shiftPLUS) and (_x<-cycle_s*(1/4)-shiftPLUS):
                __velocfunc[indx] = -a*(_x+cycle_s*(2/4)+shiftPLUS)
            elif (_x>-cycle_s*(1/4)-shiftPLUS) and (_x<cycle_s*(1/4)-shiftPLUS):
                __velocfunc[indx] = a*(_x+cycle_s*(0/4)+shiftPLUS)
            elif (_x>cycle_s*(1/4)-shiftPLUS) and (_x<cycle_s*(3/4)-shiftPLUS):
                __velocfunc[indx] = -a*(_x-cycle_s*(2/4)+shiftPLUS)
            elif (_x>cycle_s*(3/4)-shiftPLUS) and (_x<cycle_s*(5/4)-shiftPLUS):
                __velocfunc[indx] = a*(_x-cycle_s*(4/4)+shiftPLUS)
            elif (_x>cycle_s*(5/4)-shiftPLUS) and (_x<cycle_s*(7/4)-shiftPLUS):
                __velocfunc[indx] = -a*(_x-cycle_s*(6/4)+shiftPLUS)
            elif (_x>cycle_s*(7/4)-shiftPLUS) and (_x<cycle_s*(9/4)-shiftPLUS):
                __velocfunc[indx] = a*(_x-cycle_s*(8/4)+shiftPLUS)
            elif (_x>cycle_s*(9/4)-shiftPLUS) and (_x<cycle_s*(11/4)-shiftPLUS):
                __velocfunc[indx] = -a*(_x-cycle_s*(10/4)+shiftPLUS)
            elif (_x>cycle_s*(11/4)-shiftPLUS) and (_x<cycle_s*(13/4)-shiftPLUS):
                __velocfunc[indx] = a*(_x-cycle_s*(12/4)+shiftPLUS)
            elif (_x>cycle_s*(13/4)-shiftPLUS) and (_x<cycle_s*(15/4)-shiftPLUS):
                __velocfunc[indx] = -a*(_x-cycle_s*(14/4)+shiftPLUS)
            elif (_x>cycle_s*(15/4)-shiftPLUS) and (_x<cycle_s*(17/4)-shiftPLUS):
                __velocfunc[indx] = a*(_x-cycle_s*(16/4)+shiftPLUS)
            elif (_x>cycle_s*(17/4)-shiftPLUS) and (_x<cycle_s*(19/4)-shiftPLUS):
                __velocfunc[indx] = -a*(_x-cycle_s*(18/4)+shiftPLUS)
            elif (_x>cycle_s*(19/4)-shiftPLUS) and (_x<cycle_s*(21/4)-shiftPLUS):
                __velocfunc[indx] = a*(_x-cycle_s*(20/4)+shiftPLUS)    
            else:
                __velocfunc[indx] = 0
        return __velocfunc*20 # レーザキャリブレータのレンジが0.02のとき：20倍
    

    xd = np.linspace(0, turn_num*cycle_s, rawdataN)  # [s] #saito202503  turn_numかける
    estimated_curve = modelfunc(xd, shiftPLUS=shiftPLUS)

    data_velocityX = xd
    data_velocityY = estimated_curve.copy()
    data_velocityY_resol = estimated_curve.copy()

    print("MIN velocity[mm/s];  ", np.min(data_velocityY))
    print("MAX velocity[mm/s];  ", np.max(data_velocityY))
    params = {'rawdataN':rawdataN, 
              'turn_num':turn_num, 
              'summed_shift':summed_shift,
              'shiftPLUS':shiftPLUS,
              'BG_average_num':BG_average_num,
              '__VELOCITY_CUT_MIN':__VELOCITY_CUT_MIN,
              '__VELOCITY_CUT_MAX':__VELOCITY_CUT_MAX, 
              'CUT_VELOCITY':CUT_VELOCITY}
    return data_velocityX, data_velocityY, data_velocityY_resol, params




def __calibration_velocity_7(shiftPLUS=None):
    # __calibration_velocity_1 の 0_6_ISF_nbm_ver3.00.ipynb用
    # shiftPLUS,cycle_Hz,__VELOCITY_CUT_MIN,__VELOCITY_CUT_MAXとaの値を変えればOK
    
    if shiftPLUS is None: shiftPLUS = -0.0068  # フォールディング微調整 1ch0.00011408のシフト量 -0.0068init:  -0.0085 -0.0051
    # citius_frams_num = 4092  # citiusのframe数
    citius_start_cut_frames = 15
    citius_end_cut_frames = 4
    citius_rawdataN = 4096
    citius_Hz = 2.1237870808 # [Hz]  citius動作周波数
    citius_s = 1/citius_Hz

    rawdataN = 4092
    turn_num = 4
    summed_shift = 0
    BG_average_num = 50
    __VELOCITY_CUT_MIN = -35
    __VELOCITY_CUT_MAX = 35
    CUT_VELOCITY = True

    laser_coeff = 20 # レーザキャリブレータのレンジが0.02のとき：20倍   [V] => [mm/s] 変換係数
    cycle_Hz = 8.496  # [Hz] トランスデューサのFGの周波数
    cycle_s = 1/cycle_Hz # [x]
    
    
    def modelfunc(x_array, shiftPLUS=0):
        # fit: y = 244.6082305908203x + 0.03799820691347122
        a = 73.209
        # b = 0

        __velocfunc = np.zeros(x_array.shape)
        for indx, _x in enumerate(x_array):
            if (_x>-cycle_s*(9/4)-shiftPLUS) and (_x<=-cycle_s*(7/4)-shiftPLUS):
                __velocfunc[indx] = a*(_x+cycle_s*(8/4)+shiftPLUS)
            elif (_x>-cycle_s*(7/4)-shiftPLUS) and (_x<=-cycle_s*(5/4)-shiftPLUS):
                __velocfunc[indx] = -a*(_x+cycle_s*(6/4)+shiftPLUS)
            elif (_x>-cycle_s*(5/4)-shiftPLUS) and (_x<=-cycle_s*(3/4)-shiftPLUS):
                __velocfunc[indx] = a*(_x+cycle_s*(4/4)+shiftPLUS)
            elif (_x>-cycle_s*(3/4)-shiftPLUS) and (_x<=-cycle_s*(1/4)-shiftPLUS):
                __velocfunc[indx] = -a*(_x+cycle_s*(2/4)+shiftPLUS)
            elif (_x>-cycle_s*(1/4)-shiftPLUS) and (_x<=cycle_s*(1/4)-shiftPLUS):
                __velocfunc[indx] = a*(_x+cycle_s*(0/4)+shiftPLUS)
            elif (_x>cycle_s*(1/4)-shiftPLUS) and (_x<=cycle_s*(3/4)-shiftPLUS):
                __velocfunc[indx] = -a*(_x-cycle_s*(2/4)+shiftPLUS)
            elif (_x>cycle_s*(3/4)-shiftPLUS) and (_x<=cycle_s*(5/4)-shiftPLUS):
                __velocfunc[indx] = a*(_x-cycle_s*(4/4)+shiftPLUS)
            elif (_x>cycle_s*(5/4)-shiftPLUS) and (_x<=cycle_s*(7/4)-shiftPLUS):
                __velocfunc[indx] = -a*(_x-cycle_s*(6/4)+shiftPLUS)
            elif (_x>cycle_s*(7/4)-shiftPLUS) and (_x<=cycle_s*(9/4)-shiftPLUS):
                __velocfunc[indx] = a*(_x-cycle_s*(8/4)+shiftPLUS)
            elif (_x>cycle_s*(9/4)-shiftPLUS) and (_x<=cycle_s*(11/4)-shiftPLUS):
                __velocfunc[indx] = -a*(_x-cycle_s*(10/4)+shiftPLUS)
            elif (_x>cycle_s*(11/4)-shiftPLUS) and (_x<=cycle_s*(13/4)-shiftPLUS):
                __velocfunc[indx] = a*(_x-cycle_s*(12/4)+shiftPLUS)
            elif (_x>cycle_s*(13/4)-shiftPLUS) and (_x<=cycle_s*(15/4)-shiftPLUS):
                __velocfunc[indx] = -a*(_x-cycle_s*(14/4)+shiftPLUS)
            elif (_x>cycle_s*(15/4)-shiftPLUS) and (_x<=cycle_s*(17/4)-shiftPLUS):
                __velocfunc[indx] = a*(_x-cycle_s*(16/4)+shiftPLUS)
            elif (_x>cycle_s*(17/4)-shiftPLUS) and (_x<=cycle_s*(19/4)-shiftPLUS):
                __velocfunc[indx] = -a*(_x-cycle_s*(18/4)+shiftPLUS)
            elif (_x>cycle_s*(19/4)-shiftPLUS) and (_x<=cycle_s*(21/4)-shiftPLUS):
                __velocfunc[indx] = a*(_x-cycle_s*(20/4)+shiftPLUS)
            elif (_x>cycle_s*(21/4)-shiftPLUS) and (_x<=cycle_s*(23/4)-shiftPLUS):
                __velocfunc[indx] = -a*(_x-cycle_s*(22/4)+shiftPLUS)
            elif (_x>cycle_s*(23/4)-shiftPLUS) and (_x<=cycle_s*(25/4)-shiftPLUS):
                __velocfunc[indx] = a*(_x-cycle_s*(24/4)+shiftPLUS)
            else:
                __velocfunc[indx] = 0
        return __velocfunc*laser_coeff
    

    data_velocityX = np.arange(0, citius_s, citius_s/citius_rawdataN) # [s]
    estimated_curve = modelfunc(data_velocityX, shiftPLUS=shiftPLUS)[citius_start_cut_frames:-citius_end_cut_frames]
    data_velocityY = estimated_curve.copy()
    data_velocityY_resol = estimated_curve.copy()
    print("MIN velocity[mm/s];  ", np.min(data_velocityY))
    print("MAX velocity[mm/s];  ", np.max(data_velocityY))
    params = {'rawdataN':rawdataN, 
              'turn_num':turn_num, 
              'summed_shift':summed_shift,
              'shiftPLUS':shiftPLUS,
              'BG_average_num':BG_average_num,
              '__VELOCITY_CUT_MIN':__VELOCITY_CUT_MIN,
              '__VELOCITY_CUT_MAX':__VELOCITY_CUT_MAX, 
              'CUT_VELOCITY':CUT_VELOCITY}
    return data_velocityX, data_velocityY, data_velocityY_resol, params



def __calibration_velocity_8(shiftPLUS=None):
    # __calibration_velocity_2 の 0_6_ISF_nbm_ver3.00.ipynb用
    # shiftPLUS,cycle_Hz,__VELOCITY_CUT_MIN,__VELOCITY_CUT_MAXとaの値を変えればOK
    
    if shiftPLUS is None: shiftPLUS = 0.0014+0.000 #0.0014 # フォールディング微調整 1ch0.00011408のシフト量
    # citius_frams_num = 4092  # citiusのframe数
    citius_start_cut_frames = 15
    citius_end_cut_frames = 4
    citius_rawdataN = 4096
    citius_Hz = 2.1237870808 # [Hz]  citius動作周波数
    citius_s = 1/citius_Hz

    rawdataN = 4092
    turn_num = 4
    summed_shift = 0
    BG_average_num = 50
    __VELOCITY_CUT_MIN = -120
    __VELOCITY_CUT_MAX = 120
    CUT_VELOCITY = True

    laser_coeff = 20 # レーザキャリブレータのレンジが0.02のとき：20倍   [V] => [mm/s] 変換係数
    cycle_Hz = 8.496  # [Hz] トランスデューサのFGの周波数
    cycle_s = 1/cycle_Hz # [x]
    
    
    def modelfunc(x_array, shiftPLUS=0):
        # fit: y = 244.6082305908203x + 0.03799820691347122
        a = 244.6082305908203
        # b = 0

        __velocfunc = np.zeros(x_array.shape)
        for indx, _x in enumerate(x_array):
            if (_x>-cycle_s*(9/4)-shiftPLUS) and (_x<=-cycle_s*(7/4)-shiftPLUS):
                __velocfunc[indx] = a*(_x+cycle_s*(8/4)+shiftPLUS)
            elif (_x>-cycle_s*(7/4)-shiftPLUS) and (_x<=-cycle_s*(5/4)-shiftPLUS):
                __velocfunc[indx] = -a*(_x+cycle_s*(6/4)+shiftPLUS)
            elif (_x>-cycle_s*(5/4)-shiftPLUS) and (_x<=-cycle_s*(3/4)-shiftPLUS):
                __velocfunc[indx] = a*(_x+cycle_s*(4/4)+shiftPLUS)
            elif (_x>-cycle_s*(3/4)-shiftPLUS) and (_x<=-cycle_s*(1/4)-shiftPLUS):
                __velocfunc[indx] = -a*(_x+cycle_s*(2/4)+shiftPLUS)
            elif (_x>-cycle_s*(1/4)-shiftPLUS) and (_x<=cycle_s*(1/4)-shiftPLUS):
                __velocfunc[indx] = a*(_x+cycle_s*(0/4)+shiftPLUS)
            elif (_x>cycle_s*(1/4)-shiftPLUS) and (_x<=cycle_s*(3/4)-shiftPLUS):
                __velocfunc[indx] = -a*(_x-cycle_s*(2/4)+shiftPLUS)
            elif (_x>cycle_s*(3/4)-shiftPLUS) and (_x<=cycle_s*(5/4)-shiftPLUS):
                __velocfunc[indx] = a*(_x-cycle_s*(4/4)+shiftPLUS)
            elif (_x>cycle_s*(5/4)-shiftPLUS) and (_x<=cycle_s*(7/4)-shiftPLUS):
                __velocfunc[indx] = -a*(_x-cycle_s*(6/4)+shiftPLUS)
            elif (_x>cycle_s*(7/4)-shiftPLUS) and (_x<=cycle_s*(9/4)-shiftPLUS):
                __velocfunc[indx] = a*(_x-cycle_s*(8/4)+shiftPLUS)
            elif (_x>cycle_s*(9/4)-shiftPLUS) and (_x<=cycle_s*(11/4)-shiftPLUS):
                __velocfunc[indx] = -a*(_x-cycle_s*(10/4)+shiftPLUS)
            elif (_x>cycle_s*(11/4)-shiftPLUS) and (_x<=cycle_s*(13/4)-shiftPLUS):
                __velocfunc[indx] = a*(_x-cycle_s*(12/4)+shiftPLUS)
            elif (_x>cycle_s*(13/4)-shiftPLUS) and (_x<=cycle_s*(15/4)-shiftPLUS):
                __velocfunc[indx] = -a*(_x-cycle_s*(14/4)+shiftPLUS)
            elif (_x>cycle_s*(15/4)-shiftPLUS) and (_x<=cycle_s*(17/4)-shiftPLUS):
                __velocfunc[indx] = a*(_x-cycle_s*(16/4)+shiftPLUS)
            elif (_x>cycle_s*(17/4)-shiftPLUS) and (_x<=cycle_s*(19/4)-shiftPLUS):
                __velocfunc[indx] = -a*(_x-cycle_s*(18/4)+shiftPLUS)
            elif (_x>cycle_s*(19/4)-shiftPLUS) and (_x<=cycle_s*(21/4)-shiftPLUS):
                __velocfunc[indx] = a*(_x-cycle_s*(20/4)+shiftPLUS)
            elif (_x>cycle_s*(21/4)-shiftPLUS) and (_x<=cycle_s*(23/4)-shiftPLUS):
                __velocfunc[indx] = -a*(_x-cycle_s*(22/4)+shiftPLUS)
            elif (_x>cycle_s*(23/4)-shiftPLUS) and (_x<=cycle_s*(25/4)-shiftPLUS):
                __velocfunc[indx] = a*(_x-cycle_s*(24/4)+shiftPLUS)
            else:
                __velocfunc[indx] = 0
        return __velocfunc*laser_coeff
    

    data_velocityX = np.arange(0, citius_s, citius_s/citius_rawdataN) # [s]
    estimated_curve = modelfunc(data_velocityX, shiftPLUS=shiftPLUS)[citius_start_cut_frames:-citius_end_cut_frames]
    data_velocityY = estimated_curve.copy()
    data_velocityY_resol = estimated_curve.copy()
    print("MIN velocity[mm/s];  ", np.min(data_velocityY))
    print("MAX velocity[mm/s];  ", np.max(data_velocityY))
    params = {'rawdataN':rawdataN, 
              'turn_num':turn_num, 
              'summed_shift':summed_shift,
              'shiftPLUS':shiftPLUS,
              'BG_average_num':BG_average_num,
              '__VELOCITY_CUT_MIN':__VELOCITY_CUT_MIN,
              '__VELOCITY_CUT_MAX':__VELOCITY_CUT_MAX, 
              'CUT_VELOCITY':CUT_VELOCITY}
    return data_velocityX, data_velocityY, data_velocityY_resol, params



def __calibration_velocity_9(shiftPLUS=None):
    # __calibration_velocity_3 の 0_6_ISF_nbm_ver3.00.ipynb用
    # shiftPLUS,cycle_Hz,__VELOCITY_CUT_MIN,__VELOCITY_CUT_MAXとaの値を変えればOK
    
    if shiftPLUS is None: shiftPLUS = 0.0584 #0.0014 # フォールディング微調整 1ch0.00011408のシフト量
    # citius_frams_num = 4092  # citiusのframe数
    citius_start_cut_frames = 15
    citius_end_cut_frames = 4
    citius_rawdataN = 4096
    citius_Hz = 2.1237870808 # [Hz]  citius動作周波数
    citius_s = 1/citius_Hz

    rawdataN = 4092
    turn_num = 4
    summed_shift = 0
    BG_average_num = 50
    __VELOCITY_CUT_MIN = -4
    __VELOCITY_CUT_MAX = 4
    CUT_VELOCITY = True

    laser_coeff = 20 # レーザキャリブレータのレンジが0.02のとき：20倍   [V] => [mm/s] 変換係数
    cycle_Hz = 8.496/2  # [Hz] トランスデューサのFGの周波数
    cycle_s = 1/cycle_Hz # [x]
    
    
    def modelfunc(x_array, shiftPLUS=0):
        # fit: y = 244.6082305908203x + 0.03799820691347122
        a = 7.196/2
        # b = 0

        __velocfunc = np.zeros(x_array.shape)
        for indx, _x in enumerate(x_array):
            if (_x>-cycle_s*(9/4)-shiftPLUS) and (_x<=-cycle_s*(7/4)-shiftPLUS):
                __velocfunc[indx] = a*(_x+cycle_s*(8/4)+shiftPLUS)
            elif (_x>-cycle_s*(7/4)-shiftPLUS) and (_x<=-cycle_s*(5/4)-shiftPLUS):
                __velocfunc[indx] = -a*(_x+cycle_s*(6/4)+shiftPLUS)
            elif (_x>-cycle_s*(5/4)-shiftPLUS) and (_x<=-cycle_s*(3/4)-shiftPLUS):
                __velocfunc[indx] = a*(_x+cycle_s*(4/4)+shiftPLUS)
            elif (_x>-cycle_s*(3/4)-shiftPLUS) and (_x<=-cycle_s*(1/4)-shiftPLUS):
                __velocfunc[indx] = -a*(_x+cycle_s*(2/4)+shiftPLUS)
            elif (_x>-cycle_s*(1/4)-shiftPLUS) and (_x<=cycle_s*(1/4)-shiftPLUS):
                __velocfunc[indx] = a*(_x+cycle_s*(0/4)+shiftPLUS)
            elif (_x>cycle_s*(1/4)-shiftPLUS) and (_x<=cycle_s*(3/4)-shiftPLUS):
                __velocfunc[indx] = -a*(_x-cycle_s*(2/4)+shiftPLUS)
            elif (_x>cycle_s*(3/4)-shiftPLUS) and (_x<=cycle_s*(5/4)-shiftPLUS):
                __velocfunc[indx] = a*(_x-cycle_s*(4/4)+shiftPLUS)
            elif (_x>cycle_s*(5/4)-shiftPLUS) and (_x<=cycle_s*(7/4)-shiftPLUS):
                __velocfunc[indx] = -a*(_x-cycle_s*(6/4)+shiftPLUS)
            elif (_x>cycle_s*(7/4)-shiftPLUS) and (_x<=cycle_s*(9/4)-shiftPLUS):
                __velocfunc[indx] = a*(_x-cycle_s*(8/4)+shiftPLUS)
            elif (_x>cycle_s*(9/4)-shiftPLUS) and (_x<=cycle_s*(11/4)-shiftPLUS):
                __velocfunc[indx] = -a*(_x-cycle_s*(10/4)+shiftPLUS)
            elif (_x>cycle_s*(11/4)-shiftPLUS) and (_x<=cycle_s*(13/4)-shiftPLUS):
                __velocfunc[indx] = a*(_x-cycle_s*(12/4)+shiftPLUS)
            elif (_x>cycle_s*(13/4)-shiftPLUS) and (_x<=cycle_s*(15/4)-shiftPLUS):
                __velocfunc[indx] = -a*(_x-cycle_s*(14/4)+shiftPLUS)
            elif (_x>cycle_s*(15/4)-shiftPLUS) and (_x<=cycle_s*(17/4)-shiftPLUS):
                __velocfunc[indx] = a*(_x-cycle_s*(16/4)+shiftPLUS)
            elif (_x>cycle_s*(17/4)-shiftPLUS) and (_x<=cycle_s*(19/4)-shiftPLUS):
                __velocfunc[indx] = -a*(_x-cycle_s*(18/4)+shiftPLUS)
            elif (_x>cycle_s*(19/4)-shiftPLUS) and (_x<=cycle_s*(21/4)-shiftPLUS):
                __velocfunc[indx] = a*(_x-cycle_s*(20/4)+shiftPLUS)
            elif (_x>cycle_s*(21/4)-shiftPLUS) and (_x<=cycle_s*(23/4)-shiftPLUS):
                __velocfunc[indx] = -a*(_x-cycle_s*(22/4)+shiftPLUS)
            elif (_x>cycle_s*(23/4)-shiftPLUS) and (_x<=cycle_s*(25/4)-shiftPLUS):
                __velocfunc[indx] = a*(_x-cycle_s*(24/4)+shiftPLUS)
            else:
                __velocfunc[indx] = 0
        return __velocfunc*laser_coeff
    

    data_velocityX = np.arange(0, citius_s, citius_s/citius_rawdataN) # [s]
    estimated_curve = modelfunc(data_velocityX, shiftPLUS=shiftPLUS)[citius_start_cut_frames:-citius_end_cut_frames]
    data_velocityY = estimated_curve.copy()
    data_velocityY_resol = estimated_curve.copy()
    print("MIN velocity[mm/s];  ", np.min(data_velocityY))
    print("MAX velocity[mm/s];  ", np.max(data_velocityY))
    params = {'rawdataN':rawdataN, 
              'turn_num':turn_num, 
              'summed_shift':summed_shift,
              'shiftPLUS':shiftPLUS,
              'BG_average_num':BG_average_num,
              '__VELOCITY_CUT_MIN':__VELOCITY_CUT_MIN,
              '__VELOCITY_CUT_MAX':__VELOCITY_CUT_MAX, 
              'CUT_VELOCITY':CUT_VELOCITY}
    return data_velocityX, data_velocityY, data_velocityY_resol, params



def __calibration_velocity_10(shiftPLUS=None):
    # __calibration_velocity_4 の 0_6_ISF_nbm_ver3.00.ipynb用
    # shiftPLUS,cycle_Hz,__VELOCITY_CUT_MIN,__VELOCITY_CUT_MAXとaの値を変えればOK
    
    if shiftPLUS is None: shiftPLUS = 0.0605+0.00025  # フォールディング微調整 1ch0.00011408のシフト量 0.0605+0.00000 
    # citius_frams_num = 4092  # citiusのframe数
    citius_start_cut_frames = 15
    citius_end_cut_frames = 4
    citius_rawdataN = 4096
    citius_Hz = 2.1237870808 # [Hz]  citius動作周波数
    citius_s = 1/citius_Hz

    rawdataN = 4092
    turn_num = 4
    summed_shift = 0
    BG_average_num = 50
    __VELOCITY_CUT_MIN = -35
    __VELOCITY_CUT_MAX = 35
    CUT_VELOCITY = True

    laser_coeff = 20 # レーザキャリブレータのレンジが0.02のとき：20倍   [V] => [mm/s] 変換係数
    cycle_Hz = 8.496/2  # [Hz] トランスデューサのFGの周波数
    cycle_s = 1/cycle_Hz # [x]
    
    
    def modelfunc(x_array, shiftPLUS=0):
        # fit: y = 244.6082305908203x + 0.03799820691347122
        a = 73.209/2
        # b = 0

        __velocfunc = np.zeros(x_array.shape)
        for indx, _x in enumerate(x_array):
            if (_x>-cycle_s*(9/4)-shiftPLUS) and (_x<=-cycle_s*(7/4)-shiftPLUS):
                __velocfunc[indx] = a*(_x+cycle_s*(8/4)+shiftPLUS)
            elif (_x>-cycle_s*(7/4)-shiftPLUS) and (_x<=-cycle_s*(5/4)-shiftPLUS):
                __velocfunc[indx] = -a*(_x+cycle_s*(6/4)+shiftPLUS)
            elif (_x>-cycle_s*(5/4)-shiftPLUS) and (_x<=-cycle_s*(3/4)-shiftPLUS):
                __velocfunc[indx] = a*(_x+cycle_s*(4/4)+shiftPLUS)
            elif (_x>-cycle_s*(3/4)-shiftPLUS) and (_x<=-cycle_s*(1/4)-shiftPLUS):
                __velocfunc[indx] = -a*(_x+cycle_s*(2/4)+shiftPLUS)
            elif (_x>-cycle_s*(1/4)-shiftPLUS) and (_x<=cycle_s*(1/4)-shiftPLUS):
                __velocfunc[indx] = a*(_x+cycle_s*(0/4)+shiftPLUS)
            elif (_x>cycle_s*(1/4)-shiftPLUS) and (_x<=cycle_s*(3/4)-shiftPLUS):
                __velocfunc[indx] = -a*(_x-cycle_s*(2/4)+shiftPLUS)
            elif (_x>cycle_s*(3/4)-shiftPLUS) and (_x<=cycle_s*(5/4)-shiftPLUS):
                __velocfunc[indx] = a*(_x-cycle_s*(4/4)+shiftPLUS)
            elif (_x>cycle_s*(5/4)-shiftPLUS) and (_x<=cycle_s*(7/4)-shiftPLUS):
                __velocfunc[indx] = -a*(_x-cycle_s*(6/4)+shiftPLUS)
            elif (_x>cycle_s*(7/4)-shiftPLUS) and (_x<=cycle_s*(9/4)-shiftPLUS):
                __velocfunc[indx] = a*(_x-cycle_s*(8/4)+shiftPLUS)
            elif (_x>cycle_s*(9/4)-shiftPLUS) and (_x<=cycle_s*(11/4)-shiftPLUS):
                __velocfunc[indx] = -a*(_x-cycle_s*(10/4)+shiftPLUS)
            elif (_x>cycle_s*(11/4)-shiftPLUS) and (_x<=cycle_s*(13/4)-shiftPLUS):
                __velocfunc[indx] = a*(_x-cycle_s*(12/4)+shiftPLUS)
            elif (_x>cycle_s*(13/4)-shiftPLUS) and (_x<=cycle_s*(15/4)-shiftPLUS):
                __velocfunc[indx] = -a*(_x-cycle_s*(14/4)+shiftPLUS)
            elif (_x>cycle_s*(15/4)-shiftPLUS) and (_x<=cycle_s*(17/4)-shiftPLUS):
                __velocfunc[indx] = a*(_x-cycle_s*(16/4)+shiftPLUS)
            elif (_x>cycle_s*(17/4)-shiftPLUS) and (_x<=cycle_s*(19/4)-shiftPLUS):
                __velocfunc[indx] = -a*(_x-cycle_s*(18/4)+shiftPLUS)
            elif (_x>cycle_s*(19/4)-shiftPLUS) and (_x<=cycle_s*(21/4)-shiftPLUS):
                __velocfunc[indx] = a*(_x-cycle_s*(20/4)+shiftPLUS)
            elif (_x>cycle_s*(21/4)-shiftPLUS) and (_x<=cycle_s*(23/4)-shiftPLUS):
                __velocfunc[indx] = -a*(_x-cycle_s*(22/4)+shiftPLUS)
            elif (_x>cycle_s*(23/4)-shiftPLUS) and (_x<=cycle_s*(25/4)-shiftPLUS):
                __velocfunc[indx] = a*(_x-cycle_s*(24/4)+shiftPLUS)
            else:
                __velocfunc[indx] = 0
        return __velocfunc*laser_coeff
    

    data_velocityX = np.arange(0, citius_s, citius_s/citius_rawdataN) # [s]
    estimated_curve = modelfunc(data_velocityX, shiftPLUS=shiftPLUS)[citius_start_cut_frames:-citius_end_cut_frames]
    data_velocityY = estimated_curve.copy()
    data_velocityY_resol = estimated_curve.copy()
    print("MIN velocity[mm/s];  ", np.min(data_velocityY))
    print("MAX velocity[mm/s];  ", np.max(data_velocityY))
    params = {'rawdataN':rawdataN, 
              'turn_num':turn_num, 
              'summed_shift':summed_shift,
              'shiftPLUS':shiftPLUS,
              'BG_average_num':BG_average_num,
              '__VELOCITY_CUT_MIN':__VELOCITY_CUT_MIN,
              '__VELOCITY_CUT_MAX':__VELOCITY_CUT_MAX, 
              'CUT_VELOCITY':CUT_VELOCITY}
    return data_velocityX, data_velocityY, data_velocityY_resol, params











#%%
def __calibration_velocity_else(shiftPLUS=None):
    if shiftPLUS is None: shiftPLUS = -1.9
    priodT = 4.34539195   # [Hz]
    rawdataN = 2048
    turn_num = 1
    summed_shift = 525
    BG_average_num = 50
    __VELOCITY_CUT_MIN = -35
    __VELOCITY_CUT_MAX = 35
    CUT_VELOCITY = True
    
    cycle_time=1/priodT
    # cycle_time=0.117714
    
    cycle_time = 1/priodT
    # cycle_time=0.117714
    
    def modelfunc(x, shiftPLUS=0, BG=0):
        AT = 41.9185160
        phiT = 1.59765608
        priodT = 4.34539195
        BG = 0
        
        model = AT*signal.sawtooth(2*np.pi*(xd+shiftPLUS)*priodT + np.pi/2 + phiT, 0.5)
        model += BG
        return model

    xd = np.linspace(0, cycle_time, rawdataN)  # [s]
    estimated_curve = modelfunc(xd, shiftPLUS=shiftPLUS)

    data_velocityX = xd
    data_velocityY = estimated_curve.copy()
    data_velocityY_resol = estimated_curve.copy()

    print("MIN velocity[mm/s];  ", np.min(data_velocityY))
    print("MAX velocity[mm/s];  ", np.max(data_velocityY))
    params = {'rawdataN':rawdataN, 
              'turn_num':turn_num, 
              'summed_shift':summed_shift,
              'shiftPLUS':shiftPLUS,
              'BG_average_num':BG_average_num,
              '__VELOCITY_CUT_MIN':__VELOCITY_CUT_MIN,
              '__VELOCITY_CUT_MAX':__VELOCITY_CUT_MAX, 
              'CUT_VELOCITY':CUT_VELOCITY}
    return data_velocityX, data_velocityY, data_velocityY_resol, params








def velocity_calib_result(velocity_num:int):
    # load 結果を元にどの関数を返すか指定する。
    if velocity_num==0:
        __calibration_velocity_tmp = __calibration_velocity_0
    elif velocity_num==1:
        __calibration_velocity_tmp = __calibration_velocity_1
    elif velocity_num==2:
        __calibration_velocity_tmp = __calibration_velocity_2
    elif velocity_num==3:
        __calibration_velocity_tmp = __calibration_velocity_3
    elif velocity_num==4:
        __calibration_velocity_tmp = __calibration_velocity_4
    elif velocity_num==5:
        __calibration_velocity_tmp = __calibration_velocity_5
    elif velocity_num==6:
        __calibration_velocity_tmp = __calibration_velocity_6
    elif velocity_num==7:
        __calibration_velocity_tmp = __calibration_velocity_7
    elif velocity_num==8:
        __calibration_velocity_tmp = __calibration_velocity_8
    elif velocity_num==9:
        __calibration_velocity_tmp = __calibration_velocity_9
    elif velocity_num==10:
        __calibration_velocity_tmp = __calibration_velocity_10
    elif velocity_num==11:
        __calibration_velocity_tmp = __calibration_velocity_11
    elif velocity_num==12:
        __calibration_velocity_tmp = __calibration_velocity_12
    elif velocity_num==13:
        __calibration_velocity_tmp = __calibration_velocity_13
    elif velocity_num==14:
        __calibration_velocity_tmp = __calibration_velocity_14
    elif velocity_num==15:
        __calibration_velocity_tmp = __calibration_velocity_15
    elif velocity_num==16:
        __calibration_velocity_tmp = __calibration_velocity_16
    else:
        __calibration_velocity_tmp = __calibration_velocity_else
    
    inspect.getsource(__calibration_velocity_tmp)
    data_velocityX, data_velocityY, data_velocityY_resol, params = __calibration_velocity_tmp()
    return data_velocityX, data_velocityY, data_velocityY_resol, params