# -*- coding: utf-8 -*-
"""メモ用のファイル
ノートで実行した結果を入力する．

"""
import numpy as np
# import matplotlib.pyplot as plt
# from scipy import signal

from nbm_module.calcM import rounding_half_up
# from nbm_module.plotlibM import plt_velocity_fit_result

# from nbm_module.plotlibM import *



#%%
######################################################################################
###########################  q キャリブレーション結果  (Si)  ###########################
######################################################################################
def __calibration_angle_0():
    # print('Result of q caliblation', '[ExpData]: ', '2023/7')
    propcoeff = 0.066174  # [nm^-1/pixel] #/0_4_1_Si_calib_calc_pixel2q.ipynbで線形フィットしたAの値を入力
    def pixel2q_inv(pixel):
        # e.g.) q[nm^-1] = 0.12301796*pixel
        return propcoeff*pixel  #[nm^-1]
    def q_inv2pixel(q_inv):
        return rounding_half_up((q_inv)/propcoeff, 0)  #[pixel]
    print('pixel2q_inv(pixel) = ', str(propcoeff),'*pixel')
    return pixel2q_inv, q_inv2pixel



def __calibration_angle_1():
    # print('Result of q caliblation', '[ExpData]: ', '2023/7')
    propcoeff = 0.072312  # [nm^-1/pixel] #/0_4_1_Si_calib_calc_pixel2q.ipynbで線形フィットしたAの値を入力
    def pixel2q_inv(pixel):
        # e.g.) q[nm^-1] = 0.12301796*pixel
        return propcoeff*pixel  #[nm^-1]
    def q_inv2pixel(q_inv):
        return rounding_half_up((q_inv)/propcoeff, 0)  #[pixel]
    print('pixel2q_inv(pixel) = ', str(propcoeff),'*pixel')
    return pixel2q_inv, q_inv2pixel



def __calibration_angle_2():
    # print('Result of q caliblation', '[ExpData]: ', '2023/7')
    propcoeff = 0.069251  # [nm^-1/pixel] #/0_4_1_Si_calib_calc_pixel2q.ipynbで線形フィットしたAの値を入力
    def pixel2q_inv(pixel):
        # e.g.) q[nm^-1] = 0.12301796*pixel
        return propcoeff*pixel  #[nm^-1]
    def q_inv2pixel(q_inv):
        return rounding_half_up((q_inv)/propcoeff, 0)  #[pixel]
    print('pixel2q_inv(pixel) = ', str(propcoeff),'*pixel')
    return pixel2q_inv, q_inv2pixel



def __calibration_angle_3(): #ゴム延伸治具
    # print('Result of q caliblation', '[ExpData]: ', '2023/7')
    propcoeff = 0.075088  # [nm^-1/pixel] #/0_4_1_Si_calib_calc_pixel2q.ipynbで線形フィットしたAの値を入力
    def pixel2q_inv(pixel):
        # e.g.) q[nm^-1] = 0.12301796*pixel
        return propcoeff*pixel  #[nm^-1]
    def q_inv2pixel(q_inv):
        return rounding_half_up((q_inv)/propcoeff, 0)  #[pixel]
    print('pixel2q_inv(pixel) = ', str(propcoeff),'*pixel')
    return pixel2q_inv, q_inv2pixel



def __calibration_angle_4():
    # print('Result of q caliblation', '[ExpData]: ', '2023/7')
    propcoeff = 0.016278  # [nm^-1/pixel] #/0_4_1_Si_calib_calc_pixel2q.ipynbで線形フィットしたAの値を入力0.14010762
    def pixel2q_inv(pixel):
        # e.g.) q[nm^-1] = 0.12301796*pixel
        return propcoeff*pixel  #[nm^-1]
    def q_inv2pixel(q_inv):
        return rounding_half_up((q_inv)/propcoeff, 0)  #[pixel]
    print('pixel2q_inv(pixel) = ', str(propcoeff),'*pixel')
    return pixel2q_inv, q_inv2pixel


def __calibration_angle_5():
    # print('Result of q caliblation', '[ExpData]: ', '2023/7')
    propcoeff = 0.069251/1.22581  # [nm^-1/pixel] #/0_4_1_Si_calib_calc_pixel2q.ipynbで線形フィットしたAの値を入力0.14010762
    def pixel2q_inv(pixel):
        # e.g.) q[nm^-1] = 0.12301796*pixel
#        return propcoeff*pixel  #[nm^-1]
        return propcoeff*pixel  #[nm^-1]
    def q_inv2pixel(q_inv):
        return rounding_half_up((q_inv)/propcoeff, 0)  #[pixel]
    print('pixel2q_inv(pixel) = ', str(propcoeff),'*pixel')
    return pixel2q_inv, q_inv2pixel


def __calibration_angle_6():
    # print('Result of q caliblation', '[ExpData]: ', '2023/7')
    propcoeff = 0.10456*0.785/4/73  # [nm^-1/pixel] #/0_4_1_Si_calib_calc_pixel2q.ipynbで線形フィットしたAの値を入力0.14010762
    def pixel2q_inv(pixel):
        # e.g.) q[nm^-1] = 0.12301796*pixel
#        return propcoeff*pixel  #[nm^-1]
        return 2*73*np.sin(2*np.arctan(propcoeff*pixel))  #[nm^-1]
    def q_inv2pixel(q_inv):
        return rounding_half_up(np.tan(np.arcsin((q_inv)/(2*73))/2)/propcoeff, 0)  #[pixel]
    print('pixel2q_inv(pixel) = ', str(propcoeff),'*pixel')
    return pixel2q_inv, q_inv2pixel
#%%
def __calibration_angle_else(samplenumber:int):
    """
    pixel2q_inv, q_inv2pixel = Si_calib_result(samplenumber)
    """
    print('Result of q caliblation', '[ExpData]: ', '2023/7')
    
    
    print('samplenumber:  ', samplenumber)
    if (type(samplenumber) is int) and (samplenumber>=0) and (samplenumber<33):
        propcoeff = 0.14010762  # [nm^-1/pixel] #/0_4_1_Si_calib_calc_pixel2q.ipynbで線形フィットしたAの値を入力
        def pixel2q_inv(pixel):
            # e.g.) q[nm^-1] = 0.12301796*pixel
            return propcoeff*pixel  #[nm^-1]
        def q_inv2pixel(q_inv):
            return rounding_half_up((q_inv)/propcoeff, 0)  #[pixel]
    
        print('pixel2q_inv(pixel) = ', str(propcoeff),'*pixel')
    
    
    elif (type(samplenumber) is int) and (samplenumber>=33):
        propcoeff = 0.126  # [nm^-1/pixel] #/0_4_1_Si_calib_calc_pixel2q.ipynbで線形フィットしたAの値を入力
        def pixel2q_inv(pixel):
            # e.g.) q[nm^-1] = 0.12301796*pixel
            return propcoeff*pixel  #[nm^-1]
        def q_inv2pixel(q_inv):
            return rounding_half_up((q_inv)/propcoeff, 0)  #[pixel]
    
        print('pixel2q_inv(pixel) = ', str(propcoeff),'*pixel')
    
    else:
        def pixel2q_inv(pixel, A:float, B:float):
            return A*pixel + B  #[nm^-1]
        def q_inv2pixel(q_inv, A:float, B:float):
            return rounding_half_up((q_inv-B)/A, 0)  #[pixel]
        print('pixel2q_inv(pixel, A:float, B:float) = A*pixel + B')

    return pixel2q_inv, q_inv2pixel




def q_calib_result(calibration_angle_num, samplenumber=None):
    # load 結果を元にどの関数を返すか指定する。
    if calibration_angle_num==0:
        pixel2q_inv, q_inv2pixel = __calibration_angle_0()
    elif calibration_angle_num==1:
        pixel2q_inv, q_inv2pixel = __calibration_angle_1()
    elif calibration_angle_num==2:
        pixel2q_inv, q_inv2pixel = __calibration_angle_2()
    elif calibration_angle_num==3:
        pixel2q_inv, q_inv2pixel = __calibration_angle_3()
    elif calibration_angle_num==4:
        pixel2q_inv, q_inv2pixel = __calibration_angle_4()
    elif calibration_angle_num==5:
        pixel2q_inv, q_inv2pixel = __calibration_angle_5()
    elif calibration_angle_num==6:
        pixel2q_inv, q_inv2pixel = __calibration_angle_6()
    else:
        pixel2q_inv, q_inv2pixel = __calibration_angle_else(samplenumber)
    return pixel2q_inv, q_inv2pixel
